﻿//////////////////////////////////////////////
// GamepadDevice.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkInputs
{
	class System ;
}

/// Includes ---------------------------------

// nkInputs
#include "../../Dll/DllDefines.h"

#include "Enums/GamepadDeviceButton.h"

#include "GamepadJoystickStatus.h"

// nkMemory
#include <NilkinsMemory/Pointers/UniquePtr.h>

/// Class ------------------------------------

namespace nkInputs
{
	class DLL_INPUTS_EXPORT GamepadDevice
	{
		public :
		
			// Constructor, destructor
			GamepadDevice (System* system) noexcept ;
			virtual ~GamepadDevice () ;

			// Getters
			System* getSystem () const ;
			virtual GamepadJoystickStatus getLeftJoystickStatus () const = 0 ;
			virtual GamepadJoystickStatus getRightJoystickStatus () const = 0 ;
			virtual float getLeftTriggerStatus () const = 0 ;
			virtual float getRightTriggerStatus () const = 0 ;
			virtual bool isButtonDown (GAMEPAD_DEVICE_BUTTON button) const = 0 ;

			// Setters
			virtual void setGamepadSlot (unsigned int v) = 0 ;
			virtual void setLeftJoystickDeadzone (float v) = 0 ;
			virtual void setRightJoystickDeadzone (float v) = 0 ;
			virtual void setTriggersDeadzone (float v) = 0 ;
			virtual void setLeftMotorVibration (float v) = 0 ;
			virtual void setRightMotorVibration (float v) = 0 ;

			// Update
			virtual void update () = 0 ;

		public :

			// Statics
			// Creation
			static nkMemory::UniquePtr<GamepadDevice> create (System* system = nullptr) ;

		protected :

			System* _system ;
	} ;
}